# establish dirs
wd<-dirname(sys.frame(1)$ofile) # get dir of sourced R script
if (!exists("getHabitatHUC")) source(file.path(wd,"AqEECsFunctionsB.R")) # load functions

eecfile<-file.choose()
temp.df<-read.csv(eecfile) # read EEC csv

temp_medians<-aggregate(temp.df[,8:11],by=list(temp.df$HUC2,temp.df$Bin,temp.df$Scenario,temp.df$Crop),FUN="median")
temp_quants<-aggregate(temp.df[,8:11],by=list(temp.df$HUC2,temp.df$Bin,temp.df$Scenario,temp.df$Crop),FUN="quant95")

temp_data<-cbind(temp_medians,temp_quants[5:8]) # combine median and range EECs

write.csv(temp_data, file=paste0(wd,"/",basename(eecfile),"_aggregated.csv"))
